/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

/**
 * Enum for the CESOP payment data message types.
 */
public enum MessageTypeEnum {

    /**
     * The message type is 'Payment data' (or 'No Payment data').
     */
    PMT("PMT", true),
    /**
     * The message type is 'Validation result message'.
     */
    VLD("VLD", true),
    /**
     * The message type is 'Ping Message'.
     */
    PNG("PNG", false),;

    private final String label;
    private final boolean businessRulesCheckEnabled;

    MessageTypeEnum(final String label, final boolean businessRulesCheckEnabled) {
        this.label = label;
        this.businessRulesCheckEnabled = businessRulesCheckEnabled;
    }

    /**
     * Gets label.
     *
     * @return the label
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Find a {@link MessageTypeEnum} by its label.
     *
     * @param label the label
     * @return the {@link MessageTypeEnum}
     * @throws IllegalArgumentException if there is no value for the label
     */
    public static MessageTypeEnum findByLabel(final String label) {
        for (final MessageTypeEnum value : values()) {
            if (value.getLabel().equals(label)) {
                return value;
            }
        }
        throw new IllegalArgumentException("No MessageTypeEnum found for label: " + label);
    }

    /**
     * Retrieves whether the check for business rules is enabled by default.
     *
     * @return true if the check for business rules is enabled by default, false otherwise.
     */
    public boolean isBusinessRulesCheckEnabled() {
        return this.businessRulesCheckEnabled;
    }
}
